using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Zad3
{


class Program
{

    public struct Point  : IComparable<Point>
    {
        public long X, Y;

        public Point(long x, long y)
        {
            X = x;
            Y = y;
        }

           public int CompareTo(Point other)
            {
                if (X == other.X)
                    return Y.CompareTo(other.Y);
                return X.CompareTo(other.X); 
            }


            public static bool operator >(Point a, Point b)
            {
                if (a.X == b.X) return a.Y < b.Y;
                return a.X < b.X;
            }

            public static bool operator <(Point a, Point b)      {
            if (a.X == b.X) return a.Y < b.Y;
            return a.X < b.X;
        }

        public static Point operator -(Point a, Point b)       {
            return new Point(a.X - b.X, a.Y - b.Y);
        }

        public static long Cross(Point a, Point b)
        {
            return a.X * b.Y - a.Y * b.X;
        }
    }


    public static long ConvexHullArea(List<Point> points)
    {
        points.Sort();

        var lower = new List<Point>();
        foreach (var p in points)
        {
            while (lower.Count >= 2 && Point.Cross(lower[lower.Count - 1] - lower[lower.Count - 2], p - lower[lower.Count - 1]) <= 0)
                lower.RemoveAt(lower.Count - 1);
            lower.Add(p);
        }


        var upper = new List<Point>();
        foreach (var p in points.Reverse<Point>())
        {
            while (upper.Count >= 2 && Point.Cross(upper[upper.Count - 1] - upper[upper.Count - 2], p - upper[upper.Count - 1]) <= 0)
                upper.RemoveAt(upper.Count - 1);
            upper.Add(p);
        }

        lower.RemoveAt(lower.Count - 1);
        upper.RemoveAt(upper.Count - 1);


        lower.AddRange(upper);

        long area = 0;
            for (int i = 0; i < lower.Count; i++)       {           int j = (i + 1) % lower.Count;
            area += lower[i].X * lower[j].Y - lower[i].Y * lower[j].X;
        }
        return Math.Abs(area) / 2;
    }

    public static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        var points = new List<Point>();
                   for (int i = 0; i < N; i++)       {
            var coords = Console.ReadLine().Split().Select(long.Parse).ToArray();
            points.Add(new Point(coords[0], coords[1]));
        }


        long maxArea = long.MinValue;

        for (int i = 0; i < N; i++)       {
            var remainingPoints = new List<Point>(points);
            remainingPoints.RemoveAt(i);
            long area = ConvexHullArea(remainingPoints);
            maxArea = Math.Max(maxArea, area);
        }

        Console.WriteLine(maxArea);
    }
}

}